/*
 * Decompiled with CFR 0.152.
 */
package lazyapp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public class LazyHTTP {
    public static int TIMEOUT = 60000;

    public static String doRequest(String method, String url, String body, boolean needGzip) {
        try {
            return LazyHTTP.doHttpsRequest(method, url, body, needGzip);
        }
        catch (Exception ex) {
            return ex.getMessage();
        }
    }

    private static HttpURLConnection getConnection(String u) throws URISyntaxException, IOException {
        HttpURLConnection uc = null;
        URL url = new URL(u);
        if ("https".equals(url.toURI().getScheme())) {
            HttpsURLConnection httpsUC = (HttpsURLConnection)url.openConnection();
            httpsUC.setSSLSocketFactory((SSLSocketFactory)SSLSocketFactory.getDefault());
            uc = httpsUC;
        } else {
            uc = (HttpURLConnection)url.openConnection();
        }
        uc.setConnectTimeout(TIMEOUT);
        uc.setReadTimeout(TIMEOUT);
        uc.setDoInput(true);
        return uc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String doHttpsRequest(String method, String url, String body, boolean needGzip) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = null;
        InputStream inputStream = null;
        HttpURLConnection uc = null;
        try {
            uc = LazyHTTP.getConnection(url);
            uc.setRequestMethod(method);
            if (body != null && "POST".equals(method)) {
                Throwable throwable;
                uc.setDoOutput(true);
                if (needGzip) {
                    throwable = null;
                    try (GZIPOutputStream g = new GZIPOutputStream(uc.getOutputStream());){
                        g.write(body.getBytes());
                        g.flush();
                    }
                    catch (Throwable x2) {
                        throwable = x2;
                        throw x2;
                    }
                }
                throwable = null;
                try (OutputStream os = uc.getOutputStream();){
                    os.write(body.getBytes());
                    os.flush();
                }
                catch (Throwable x2) {
                    throwable = x2;
                    throw x2;
                }
            }
            inputStream = uc.getInputStream();
            byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[2048];
            int received = inputStream.read(buffer);
            while (received > 0) {
                byteArrayOutputStream.write(buffer, 0, received);
                received = inputStream.read(buffer);
            }
            int responseCode = uc.getResponseCode();
            String responseBody = new String(byteArrayOutputStream.toByteArray());
            String string = "Code: " + responseCode + ". Body: " + responseBody;
            return string;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (uc != null) {
                String string = "Code: " + uc.getResponseCode() + ". Error: " + uc.getResponseMessage();
                return string;
            }
        }
        finally {
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
            if (uc != null) {
                uc.disconnect();
            }
        }
        return null;
    }
}

