/*
 * Decompiled with CFR 0.152.
 */
package lazyapp;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import lazyapp.LazyHTTP;

public class LazyFrame
extends JFrame {
    private static final double W = 0.6;
    private static final double H = 0.8;

    public LazyFrame() throws HeadlessException {
        super("Lazy app");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((int)((double)screenSize.width * 0.4 / 2.0), (int)((double)screenSize.height * 0.19999999999999996 / 2.0), (int)((double)screenSize.width * 0.6), (int)((double)screenSize.height * 0.8));
        this.setDefaultCloseOperation(3);
        this.initLayout();
        this.setVisible(true);
    }

    private void initLayout() {
        this.setLayout(new GridBagLayout());
        final JTextField urlInput = new JTextField();
        final JTextArea bodyInput = new JTextArea();
        final JCheckBox gzipChekBox = new JCheckBox("Gzip", true);
        final JTextArea logArea = new JTextArea();
        final JComboBox<String> methods = new JComboBox<String>(new String[]{"GET", "POST", "DELETE"});
        logArea.setLineWrap(true);
        logArea.setEditable(false);
        JButton sendButton = new JButton("Send");
        sendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String url = urlInput.getText();
                boolean needGzip = gzipChekBox.isSelected();
                String body = bodyInput.getText();
                if (url == null || url.isEmpty()) {
                    JOptionPane.showMessageDialog(LazyFrame.this, "Where is url?", "Error", 0);
                    return;
                }
                logArea.append(LazyFrame.getTimestamp() + "  '" + methods.getSelectedItem() + "' " + url + " with " + (needGzip ? "gziped" : "plain") + " body: " + body + "\n");
                String response = LazyHTTP.doRequest(String.valueOf(methods.getSelectedItem()), url, body, needGzip);
                logArea.append(LazyFrame.getTimestamp() + "  " + response + "\n");
            }
        });
        JButton clearLog = new JButton("Clear log");
        clearLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                logArea.setText("");
            }
        });
        this.add((Component)new JLabel("URL"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)urlInput, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)new JLabel("Body"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)new JScrollPane(bodyInput), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.7, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        JPanel controls = new JPanel();
        controls.add(sendButton);
        controls.add(methods);
        controls.add(gzipChekBox);
        controls.add(clearLog);
        this.add((Component)controls, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)new JLabel("Log"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)new JScrollPane(logArea), new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
    }

    private static String getTimestamp() {
        Calendar cal = Calendar.getInstance();
        StringBuilder timestamp = new StringBuilder();
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        timestamp.append(cal.get(1)).append("-").append(cal.get(2) + 1).append("-").append(cal.get(5)).append(" ").append(hour < 10 ? "0" + hour : Integer.valueOf(hour)).append(":").append(minute < 10 ? "0" + minute : Integer.valueOf(minute)).append(":").append(second < 10 ? "0" + second : Integer.valueOf(second));
        return timestamp.toString();
    }
}

